<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'total_price',
        'status',
        'shipping_address',
        'billing_address',
        'total_amount',
        'tax_amount',
        'platform_fee',
    ];

    public static function boot()
    {
        parent::boot();

        static::creating(function ($order) {
            $commissionRate = config('app.platform_commission_rate', 0.05); // Default to 5%
            $order->platform_fee = $order->total_amount * $commissionRate;
        });
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function items()
    {
        return $this->hasMany(OrderItem::class);
    }

    public function buyer()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function orderItems()
    {
        return $this->hasMany(OrderItem::class);
    }
}